/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetRestApisRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetRestApisRequestMarshaller
implements Marshaller<Request<GetRestApisRequest>, GetRestApisRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public GetRestApisRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetRestApisRequest> marshall(GetRestApisRequest getRestApisRequest) {
        if (getRestApisRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetRestApisRequest> request = new DefaultRequest<GetRestApisRequest>(getRestApisRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis";
        request.setResourcePath(uriResourcePath);
        if (getRestApisRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getRestApisRequest.getPosition()));
        }
        if (getRestApisRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getRestApisRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

