/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAutoScalingGroupsRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingGroupsRequest>, DescribeAutoScalingGroupsRequest> {
    @Override
    public Request<DescribeAutoScalingGroupsRequest> marshall(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        if (describeAutoScalingGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAutoScalingGroupsRequest> request = new DefaultRequest<DescribeAutoScalingGroupsRequest>(describeAutoScalingGroupsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeAutoScalingGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList autoScalingGroupNamesList = (SdkInternalList)describeAutoScalingGroupsRequest.getAutoScalingGroupNames();
        if (!autoScalingGroupNamesList.isEmpty() || !autoScalingGroupNamesList.isAutoConstruct()) {
            int autoScalingGroupNamesListIndex = 1;
            for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                if (autoScalingGroupNamesListValue != null) {
                    request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringUtils.fromString(autoScalingGroupNamesListValue));
                }
                ++autoScalingGroupNamesListIndex;
            }
        }
        if (describeAutoScalingGroupsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeAutoScalingGroupsRequest.getNextToken()));
        }
        if (describeAutoScalingGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeAutoScalingGroupsRequest.getMaxRecords()));
        }
        return request;
    }
}

