/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ResumeProcessesRequestMarshaller
implements Marshaller<Request<ResumeProcessesRequest>, ResumeProcessesRequest> {
    @Override
    public Request<ResumeProcessesRequest> marshall(ResumeProcessesRequest resumeProcessesRequest) {
        SdkInternalList scalingProcessesList;
        if (resumeProcessesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ResumeProcessesRequest> request = new DefaultRequest<ResumeProcessesRequest>(resumeProcessesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ResumeProcesses");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resumeProcessesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(resumeProcessesRequest.getAutoScalingGroupName()));
        }
        if (!(scalingProcessesList = (SdkInternalList)resumeProcessesRequest.getScalingProcesses()).isEmpty() || !scalingProcessesList.isAutoConstruct()) {
            int scalingProcessesListIndex = 1;
            for (String scalingProcessesListValue : scalingProcessesList) {
                if (scalingProcessesListValue != null) {
                    request.addParameter("ScalingProcesses.member." + scalingProcessesListIndex, StringUtils.fromString(scalingProcessesListValue));
                }
                ++scalingProcessesListIndex;
            }
        }
        return request;
    }
}

