/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.services.cloudsearchdomain.model.Bucket;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class BucketJsonUnmarshaller
implements Unmarshaller<Bucket, JsonUnmarshallerContext> {
    private static BucketJsonUnmarshaller instance;

    @Override
    public Bucket unmarshall(JsonUnmarshallerContext context) throws Exception {
        Bucket bucket = new Bucket();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("value", targetDepth)) {
                    context.nextToken();
                    bucket.setValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("count", targetDepth)) {
                    context.nextToken();
                    bucket.setCount(context.getUnmarshaller(Long.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return bucket;
    }

    public static BucketJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BucketJsonUnmarshaller();
        }
        return instance;
    }
}

