/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.LookupAttribute;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class LookupEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<LookupAttribute> lookupAttributes;
    private Date startTime;
    private Date endTime;
    private Integer maxResults;
    private String nextToken;

    public List<LookupAttribute> getLookupAttributes() {
        if (this.lookupAttributes == null) {
            this.lookupAttributes = new SdkInternalList();
        }
        return this.lookupAttributes;
    }

    public void setLookupAttributes(Collection<LookupAttribute> lookupAttributes) {
        if (lookupAttributes == null) {
            this.lookupAttributes = null;
            return;
        }
        this.lookupAttributes = new SdkInternalList<LookupAttribute>(lookupAttributes);
    }

    public LookupEventsRequest withLookupAttributes(LookupAttribute ... lookupAttributes) {
        if (this.lookupAttributes == null) {
            this.setLookupAttributes(new SdkInternalList<LookupAttribute>(lookupAttributes.length));
        }
        for (LookupAttribute ele : lookupAttributes) {
            this.lookupAttributes.add(ele);
        }
        return this;
    }

    public LookupEventsRequest withLookupAttributes(Collection<LookupAttribute> lookupAttributes) {
        this.setLookupAttributes(lookupAttributes);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public LookupEventsRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public LookupEventsRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public LookupEventsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public LookupEventsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLookupAttributes() != null) {
            sb.append("LookupAttributes: " + this.getLookupAttributes() + ",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: " + this.getEndTime() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupEventsRequest)) {
            return false;
        }
        LookupEventsRequest other = (LookupEventsRequest)obj;
        if (other.getLookupAttributes() == null ^ this.getLookupAttributes() == null) {
            return false;
        }
        if (other.getLookupAttributes() != null && !other.getLookupAttributes().equals(this.getLookupAttributes())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLookupAttributes() == null ? 0 : this.getLookupAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public LookupEventsRequest clone() {
        return (LookupEventsRequest)super.clone();
    }
}

