/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListRepositoriesRequestMarshaller
implements Marshaller<Request<ListRepositoriesRequest>, ListRepositoriesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListRepositoriesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListRepositoriesRequest> marshall(ListRepositoriesRequest listRepositoriesRequest) {
        if (listRepositoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRepositoriesRequest> request = new DefaultRequest<ListRepositoriesRequest>(listRepositoriesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.ListRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listRepositoriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listRepositoriesRequest.getNextToken());
            }
            if (listRepositoriesRequest.getSortBy() != null) {
                jsonGenerator.writeFieldName("sortBy").writeValue(listRepositoriesRequest.getSortBy());
            }
            if (listRepositoriesRequest.getOrder() != null) {
                jsonGenerator.writeFieldName("order").writeValue(listRepositoriesRequest.getOrder());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

