/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DisableStageTransitionRequestMarshaller
implements Marshaller<Request<DisableStageTransitionRequest>, DisableStageTransitionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DisableStageTransitionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DisableStageTransitionRequest> marshall(DisableStageTransitionRequest disableStageTransitionRequest) {
        if (disableStageTransitionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisableStageTransitionRequest> request = new DefaultRequest<DisableStageTransitionRequest>(disableStageTransitionRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.DisableStageTransition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (disableStageTransitionRequest.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(disableStageTransitionRequest.getPipelineName());
            }
            if (disableStageTransitionRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(disableStageTransitionRequest.getStageName());
            }
            if (disableStageTransitionRequest.getTransitionType() != null) {
                jsonGenerator.writeFieldName("transitionType").writeValue(disableStageTransitionRequest.getTransitionType());
            }
            if (disableStageTransitionRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(disableStageTransitionRequest.getReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

