/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolClientRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateUserPoolClientRequestMarshaller
implements Marshaller<Request<CreateUserPoolClientRequest>, CreateUserPoolClientRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateUserPoolClientRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateUserPoolClientRequest> marshall(CreateUserPoolClientRequest createUserPoolClientRequest) {
        if (createUserPoolClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUserPoolClientRequest> request = new DefaultRequest<CreateUserPoolClientRequest>(createUserPoolClientRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.CreateUserPoolClient");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createUserPoolClientRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(createUserPoolClientRequest.getUserPoolId());
            }
            if (createUserPoolClientRequest.getClientName() != null) {
                jsonGenerator.writeFieldName("ClientName").writeValue(createUserPoolClientRequest.getClientName());
            }
            if (createUserPoolClientRequest.getGenerateSecret() != null) {
                jsonGenerator.writeFieldName("GenerateSecret").writeValue(createUserPoolClientRequest.getGenerateSecret());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

