/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.ParameterAttribute;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.transform.ParameterAttributeJsonMarshaller;

public class ParameterObjectJsonMarshaller {
    private static ParameterObjectJsonMarshaller instance;

    public void marshall(ParameterObject parameterObject, StructuredJsonGenerator jsonGenerator) {
        if (parameterObject == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList attributesList;
            jsonGenerator.writeStartObject();
            if (parameterObject.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(parameterObject.getId());
            }
            if (!(attributesList = (SdkInternalList)parameterObject.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (ParameterAttribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    ParameterAttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ParameterObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ParameterObjectJsonMarshaller();
        }
        return instance;
    }
}

