/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.util.Throwables;

public abstract class AbstractEnumMarshaller<T extends Enum<T>>
implements DynamoDBMarshaller<T> {
    @Override
    public String marshall(T obj) {
        try {
            return ((Enum)obj).name();
        }
        catch (RuntimeException e) {
            throw Throwables.failure(e, "Unable to marshall the instance of " + obj.getClass() + " into a string");
        }
    }

    @Override
    public T unmarshall(Class<T> clazz, String obj) {
        try {
            return Enum.valueOf(clazz, obj);
        }
        catch (RuntimeException e) {
            throw Throwables.failure(e, "Unable to unmarshall the string " + obj + " into " + clazz);
        }
    }
}

