/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedTimestamp;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDocument;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBNativeBoolean;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
final class DynamoDBAnnotationRegistry {
    private static final Log log = LogFactory.getLog(DynamoDBAnnotationRegistry.class);

    DynamoDBAnnotationRegistry() {
    }

    final AnnotationMap annotationsOf(Class<?> clazz) {
        AnnotationMap annotations = new AnnotationMap();
        annotations.putAll(clazz.getAnnotations());
        annotations.removeInvalidAnnotations();
        return annotations;
    }

    final AnnotationMap annotationsOf(Method method, Field field) {
        AnnotationMap annotations = new AnnotationMap();
        if (field != null) {
            annotations.putAll(field.getAnnotations());
        }
        annotations.putAll(method.getAnnotations());
        annotations.removeInvalidAnnotations();
        return annotations;
    }

    static final class AnnotationMap {
        private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();

        private AnnotationMap() {
        }

        private final Map<Class<? extends Annotation>, Annotation> getAnnotations() {
            return this.annotations;
        }

        private final void putAll(Annotation[] annotations) {
            if (annotations != null && annotations.length > 0) {
                for (Annotation annotation : annotations) {
                    if (annotation == null || !annotation.annotationType().isAnnotationPresent(DynamoDB.class)) continue;
                    this.getAnnotations().put(annotation.annotationType(), annotation);
                }
            }
        }

        private final void removeInvalidAnnotations() {
            if (this.isAutoGeneratedKey()) {
                if (!(this.isHashKey() || this.isRangeKey() || this.isIndexHashKey() || this.isIndexRangeKey())) {
                    log.warn((Object)(this.annotationOf(DynamoDBAutoGeneratedKey.class) + " is only compatible with keys"));
                    this.getAnnotations().remove(DynamoDBAutoGeneratedKey.class);
                } else {
                    if (this.isVersion()) {
                        log.warn((Object)(this.annotationOf(DynamoDBVersionAttribute.class) + " is not compatible with " + this.annotationOf(DynamoDBAutoGeneratedKey.class)));
                        this.getAnnotations().remove(DynamoDBVersionAttribute.class);
                    }
                    if (this.isAutoGeneratedTimestamp()) {
                        throw new DynamoDBMappingException(this.annotationOf(DynamoDBAutoGeneratedTimestamp.class) + " is not compatible with " + this.annotationOf(DynamoDBAutoGeneratedKey.class));
                    }
                }
            } else if (this.isVersion()) {
                if (this.isAutoGeneratedTimestamp()) {
                    throw new DynamoDBMappingException(this.annotationOf(DynamoDBAutoGeneratedTimestamp.class) + " is not compatible with " + this.annotationOf(DynamoDBVersionAttribute.class));
                }
            } else if (this.isAutoGeneratedTimestamp() && (this.isHashKey() || this.isRangeKey())) {
                throw new DynamoDBMappingException(this.annotationOf(DynamoDBAutoGeneratedTimestamp.class) + " is not compatible with primary keys");
            }
        }

        private final <T extends Annotation> T annotationOf(Class<T> clazz) {
            return (T)this.getAnnotations().get(clazz);
        }

        final boolean isAttribute() {
            return this.getAnnotations().containsKey(DynamoDBAttribute.class);
        }

        final boolean isAutoGeneratedKey() {
            return this.getAnnotations().containsKey(DynamoDBAutoGeneratedKey.class);
        }

        final boolean isAutoGeneratedTimestamp() {
            return this.getAnnotations().containsKey(DynamoDBAutoGeneratedTimestamp.class);
        }

        final boolean isDocument() {
            return this.getAnnotations().containsKey(DynamoDBDocument.class);
        }

        final boolean isHashKey() {
            return this.getAnnotations().containsKey(DynamoDBHashKey.class);
        }

        final boolean isIgnore() {
            return this.getAnnotations().containsKey(DynamoDBIgnore.class);
        }

        final boolean isIndexHashKey() {
            return this.getAnnotations().containsKey(DynamoDBIndexHashKey.class);
        }

        final boolean isIndexRangeKey() {
            return this.getAnnotations().containsKey(DynamoDBIndexRangeKey.class);
        }

        final boolean isMarshalling() {
            return this.getAnnotations().containsKey(DynamoDBMarshalling.class);
        }

        final boolean isNativeBoolean() {
            return this.getAnnotations().containsKey(DynamoDBNativeBoolean.class);
        }

        final boolean isRangeKey() {
            return this.getAnnotations().containsKey(DynamoDBRangeKey.class);
        }

        final boolean isTable() {
            return this.getAnnotations().containsKey(DynamoDBTable.class);
        }

        final boolean isVersion() {
            return this.getAnnotations().containsKey(DynamoDBVersionAttribute.class);
        }

        final String getAttributeName() {
            Annotation annotation;
            if (this.isHashKey() && !(annotation = this.annotationOf(DynamoDBHashKey.class)).attributeName().isEmpty()) {
                return annotation.attributeName();
            }
            if (this.isIndexHashKey() && !(annotation = this.annotationOf(DynamoDBIndexHashKey.class)).attributeName().isEmpty()) {
                return annotation.attributeName();
            }
            if (this.isRangeKey() && !(annotation = this.annotationOf(DynamoDBRangeKey.class)).attributeName().isEmpty()) {
                return annotation.attributeName();
            }
            if (this.isIndexRangeKey() && !(annotation = this.annotationOf(DynamoDBIndexRangeKey.class)).attributeName().isEmpty()) {
                return annotation.attributeName();
            }
            if (this.isAttribute() && !(annotation = this.annotationOf(DynamoDBAttribute.class)).attributeName().isEmpty()) {
                return annotation.attributeName();
            }
            if (this.isVersion() && !(annotation = this.annotationOf(DynamoDBVersionAttribute.class)).attributeName().isEmpty()) {
                return annotation.attributeName();
            }
            return null;
        }

        final Collection<String> getGlobalSecondaryIndexNamesOfIndexHashKey() {
            DynamoDBIndexHashKey annotation = this.annotationOf(DynamoDBIndexHashKey.class);
            if (annotation == null) {
                return Collections.emptySet();
            }
            return AnnotationMap.resolveIndexNames(annotation, annotation.globalSecondaryIndexName(), annotation.globalSecondaryIndexNames());
        }

        final Collection<String> getGlobalSecondaryIndexNamesOfIndexRangeKey() {
            DynamoDBIndexRangeKey annotation = this.annotationOf(DynamoDBIndexRangeKey.class);
            if (annotation == null) {
                return Collections.emptySet();
            }
            return AnnotationMap.resolveIndexNames(annotation, annotation.globalSecondaryIndexName(), annotation.globalSecondaryIndexNames());
        }

        final Collection<String> getLocalSecondaryIndexNamesOfIndexRangeKey() {
            DynamoDBIndexRangeKey annotation = this.annotationOf(DynamoDBIndexRangeKey.class);
            if (annotation == null) {
                return Collections.emptySet();
            }
            return AnnotationMap.resolveIndexNames(annotation, annotation.localSecondaryIndexName(), annotation.localSecondaryIndexNames());
        }

        final DynamoDBAutoGenerateStrategy getAutoGenerateStrategy() {
            DynamoDBAutoGeneratedTimestamp annotation = this.annotationOf(DynamoDBAutoGeneratedTimestamp.class);
            if (annotation == null) {
                return null;
            }
            return annotation.strategy();
        }

        final Class<? extends DynamoDBMarshaller<?>> getMarshallerClass() {
            DynamoDBMarshalling annotation = this.annotationOf(DynamoDBMarshalling.class);
            if (annotation == null) {
                return null;
            }
            return annotation.marshallerClass();
        }

        final String getTableName() {
            DynamoDBTable annotation = this.annotationOf(DynamoDBTable.class);
            if (annotation == null) {
                return null;
            }
            return annotation.tableName();
        }

        private static final Collection<String> resolveIndexNames(Annotation annotation, String name, String[] names) {
            if (name == null || name.isEmpty()) {
                if (names == null || names.length == 0) {
                    return Collections.emptySet();
                }
                return Arrays.asList(names);
            }
            if (names == null || names.length == 0) {
                return Collections.singleton(name);
            }
            throw new DynamoDBMappingException(annotation + " contain both index name and names");
        }
    }
}

