/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexUpdateJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateTableRequestMarshaller
implements Marshaller<Request<UpdateTableRequest>, UpdateTableRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateTableRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateTableRequest> marshall(UpdateTableRequest updateTableRequest) {
        if (updateTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTableRequest> request = new DefaultRequest<UpdateTableRequest>(updateTableRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.UpdateTable");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<AttributeDefinition> attributeDefinitionsList = updateTableRequest.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonGenerator.writeFieldName("AttributeDefinitions");
                jsonGenerator.writeStartArray();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    AttributeDefinitionJsonMarshaller.getInstance().marshall(attributeDefinitionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateTableRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(updateTableRequest.getTableName());
            }
            if (updateTableRequest.getProvisionedThroughput() != null) {
                jsonGenerator.writeFieldName("ProvisionedThroughput");
                ProvisionedThroughputJsonMarshaller.getInstance().marshall(updateTableRequest.getProvisionedThroughput(), jsonGenerator);
            }
            if ((globalSecondaryIndexUpdatesList = updateTableRequest.getGlobalSecondaryIndexUpdates()) != null) {
                jsonGenerator.writeFieldName("GlobalSecondaryIndexUpdates");
                jsonGenerator.writeStartArray();
                for (GlobalSecondaryIndexUpdate globalSecondaryIndexUpdatesListValue : globalSecondaryIndexUpdatesList) {
                    if (globalSecondaryIndexUpdatesListValue == null) continue;
                    GlobalSecondaryIndexUpdateJsonMarshaller.getInstance().marshall(globalSecondaryIndexUpdatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateTableRequest.getStreamSpecification() != null) {
                jsonGenerator.writeFieldName("StreamSpecification");
                StreamSpecificationJsonMarshaller.getInstance().marshall(updateTableRequest.getStreamSpecification(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

