/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.services.ec2.model.transform.ImportVolumeRequestMarshaller;
import java.io.Serializable;

public class ImportVolumeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ImportVolumeRequest> {
    private String availabilityZone;
    private DiskImageDetail image;
    private String description;
    private VolumeDetail volume;

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public ImportVolumeRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setImage(DiskImageDetail image) {
        this.image = image;
    }

    public DiskImageDetail getImage() {
        return this.image;
    }

    public ImportVolumeRequest withImage(DiskImageDetail image) {
        this.setImage(image);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportVolumeRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setVolume(VolumeDetail volume) {
        this.volume = volume;
    }

    public VolumeDetail getVolume() {
        return this.volume;
    }

    public ImportVolumeRequest withVolume(VolumeDetail volume) {
        this.setVolume(volume);
        return this;
    }

    @Override
    public Request<ImportVolumeRequest> getDryRunRequest() {
        Request<ImportVolumeRequest> request = new ImportVolumeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getImage() != null) {
            sb.append("Image: " + this.getImage() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getVolume() != null) {
            sb.append("Volume: " + this.getVolume());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeRequest)) {
            return false;
        }
        ImportVolumeRequest other = (ImportVolumeRequest)obj;
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVolume() == null ^ this.getVolume() == null) {
            return false;
        }
        return other.getVolume() == null || other.getVolume().equals(this.getVolume());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVolume() == null ? 0 : this.getVolume().hashCode());
        return hashCode;
    }

    @Override
    public ImportVolumeRequest clone() {
        return (ImportVolumeRequest)super.clone();
    }
}

