/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.SubnetState;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Subnet
implements Serializable,
Cloneable {
    private String subnetId;
    private String state;
    private String vpcId;
    private String cidrBlock;
    private Integer availableIpAddressCount;
    private String availabilityZone;
    private Boolean defaultForAz;
    private Boolean mapPublicIpOnLaunch;
    private SdkInternalList<Tag> tags;

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Subnet withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Subnet withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(SubnetState state) {
        this.state = state.toString();
    }

    public Subnet withState(SubnetState state) {
        this.setState(state);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Subnet withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public Subnet withCidrBlock(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
        return this;
    }

    public void setAvailableIpAddressCount(Integer availableIpAddressCount) {
        this.availableIpAddressCount = availableIpAddressCount;
    }

    public Integer getAvailableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public Subnet withAvailableIpAddressCount(Integer availableIpAddressCount) {
        this.setAvailableIpAddressCount(availableIpAddressCount);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Subnet withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setDefaultForAz(Boolean defaultForAz) {
        this.defaultForAz = defaultForAz;
    }

    public Boolean getDefaultForAz() {
        return this.defaultForAz;
    }

    public Subnet withDefaultForAz(Boolean defaultForAz) {
        this.setDefaultForAz(defaultForAz);
        return this;
    }

    public Boolean isDefaultForAz() {
        return this.defaultForAz;
    }

    public void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
        this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
    }

    public Boolean getMapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public Subnet withMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
        this.setMapPublicIpOnLaunch(mapPublicIpOnLaunch);
        return this;
    }

    public Boolean isMapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public Subnet withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Subnet withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: " + this.getCidrBlock() + ",");
        }
        if (this.getAvailableIpAddressCount() != null) {
            sb.append("AvailableIpAddressCount: " + this.getAvailableIpAddressCount() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getDefaultForAz() != null) {
            sb.append("DefaultForAz: " + this.getDefaultForAz() + ",");
        }
        if (this.getMapPublicIpOnLaunch() != null) {
            sb.append("MapPublicIpOnLaunch: " + this.getMapPublicIpOnLaunch() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getAvailableIpAddressCount() == null ^ this.getAvailableIpAddressCount() == null) {
            return false;
        }
        if (other.getAvailableIpAddressCount() != null && !other.getAvailableIpAddressCount().equals(this.getAvailableIpAddressCount())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDefaultForAz() == null ^ this.getDefaultForAz() == null) {
            return false;
        }
        if (other.getDefaultForAz() != null && !other.getDefaultForAz().equals(this.getDefaultForAz())) {
            return false;
        }
        if (other.getMapPublicIpOnLaunch() == null ^ this.getMapPublicIpOnLaunch() == null) {
            return false;
        }
        if (other.getMapPublicIpOnLaunch() != null && !other.getMapPublicIpOnLaunch().equals(this.getMapPublicIpOnLaunch())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableIpAddressCount() == null ? 0 : this.getAvailableIpAddressCount().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultForAz() == null ? 0 : this.getDefaultForAz().hashCode());
        hashCode = 31 * hashCode + (this.getMapPublicIpOnLaunch() == null ? 0 : this.getMapPublicIpOnLaunch().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Subnet clone() {
        try {
            return (Subnet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

