/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateNatGatewayRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateNatGatewayRequestMarshaller
implements Marshaller<Request<CreateNatGatewayRequest>, CreateNatGatewayRequest> {
    @Override
    public Request<CreateNatGatewayRequest> marshall(CreateNatGatewayRequest createNatGatewayRequest) {
        if (createNatGatewayRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateNatGatewayRequest> request = new DefaultRequest<CreateNatGatewayRequest>(createNatGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNatGateway");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNatGatewayRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(createNatGatewayRequest.getSubnetId()));
        }
        if (createNatGatewayRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString(createNatGatewayRequest.getAllocationId()));
        }
        if (createNatGatewayRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createNatGatewayRequest.getClientToken()));
        }
        return request;
    }
}

