/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpcClassicLinkDnsSupportRequestMarshaller
implements Marshaller<Request<DescribeVpcClassicLinkDnsSupportRequest>, DescribeVpcClassicLinkDnsSupportRequest> {
    @Override
    public Request<DescribeVpcClassicLinkDnsSupportRequest> marshall(DescribeVpcClassicLinkDnsSupportRequest describeVpcClassicLinkDnsSupportRequest) {
        if (describeVpcClassicLinkDnsSupportRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVpcClassicLinkDnsSupportRequest> request = new DefaultRequest<DescribeVpcClassicLinkDnsSupportRequest>(describeVpcClassicLinkDnsSupportRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcClassicLinkDnsSupport");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList vpcIdsList = (SdkInternalList)describeVpcClassicLinkDnsSupportRequest.getVpcIds();
        if (!vpcIdsList.isEmpty() || !vpcIdsList.isAutoConstruct()) {
            int vpcIdsListIndex = 1;
            for (String vpcIdsListValue : vpcIdsList) {
                if (vpcIdsListValue != null) {
                    request.addParameter("VpcIds." + vpcIdsListIndex, StringUtils.fromString(vpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        if (describeVpcClassicLinkDnsSupportRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVpcClassicLinkDnsSupportRequest.getMaxResults()));
        }
        if (describeVpcClassicLinkDnsSupportRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVpcClassicLinkDnsSupportRequest.getNextToken()));
        }
        return request;
    }
}

