/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.GetConsoleScreenshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetConsoleScreenshotRequestMarshaller
implements Marshaller<Request<GetConsoleScreenshotRequest>, GetConsoleScreenshotRequest> {
    @Override
    public Request<GetConsoleScreenshotRequest> marshall(GetConsoleScreenshotRequest getConsoleScreenshotRequest) {
        if (getConsoleScreenshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetConsoleScreenshotRequest> request = new DefaultRequest<GetConsoleScreenshotRequest>(getConsoleScreenshotRequest, "AmazonEC2");
        request.addParameter("Action", "GetConsoleScreenshot");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getConsoleScreenshotRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(getConsoleScreenshotRequest.getInstanceId()));
        }
        if (getConsoleScreenshotRequest.getWakeUp() != null) {
            request.addParameter("WakeUp", StringUtils.fromBoolean(getConsoleScreenshotRequest.getWakeUp()));
        }
        return request;
    }
}

