/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.services.ecr.model.ImageFailure;
import com.amazonaws.services.ecr.model.ImageIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDeleteImageResult
implements Serializable,
Cloneable {
    private List<ImageIdentifier> imageIds;
    private List<ImageFailure> failures;

    public List<ImageIdentifier> getImageIds() {
        return this.imageIds;
    }

    public void setImageIds(Collection<ImageIdentifier> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
            return;
        }
        this.imageIds = new ArrayList<ImageIdentifier>(imageIds);
    }

    public BatchDeleteImageResult withImageIds(ImageIdentifier ... imageIds) {
        if (this.imageIds == null) {
            this.setImageIds(new ArrayList<ImageIdentifier>(imageIds.length));
        }
        for (ImageIdentifier ele : imageIds) {
            this.imageIds.add(ele);
        }
        return this;
    }

    public BatchDeleteImageResult withImageIds(Collection<ImageIdentifier> imageIds) {
        this.setImageIds(imageIds);
        return this;
    }

    public List<ImageFailure> getFailures() {
        return this.failures;
    }

    public void setFailures(Collection<ImageFailure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        this.failures = new ArrayList<ImageFailure>(failures);
    }

    public BatchDeleteImageResult withFailures(ImageFailure ... failures) {
        if (this.failures == null) {
            this.setFailures(new ArrayList<ImageFailure>(failures.length));
        }
        for (ImageFailure ele : failures) {
            this.failures.add(ele);
        }
        return this;
    }

    public BatchDeleteImageResult withFailures(Collection<ImageFailure> failures) {
        this.setFailures(failures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageIds() != null) {
            sb.append("ImageIds: " + this.getImageIds() + ",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: " + this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImageResult)) {
            return false;
        }
        BatchDeleteImageResult other = (BatchDeleteImageResult)obj;
        if (other.getImageIds() == null ^ this.getImageIds() == null) {
            return false;
        }
        if (other.getImageIds() != null && !other.getImageIds().equals(this.getImageIds())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageIds() == null ? 0 : this.getImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public BatchDeleteImageResult clone() {
        try {
            return (BatchDeleteImageResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

