/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.InitiateLayerUploadRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class InitiateLayerUploadRequestMarshaller
implements Marshaller<Request<InitiateLayerUploadRequest>, InitiateLayerUploadRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public InitiateLayerUploadRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<InitiateLayerUploadRequest> marshall(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        if (initiateLayerUploadRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<InitiateLayerUploadRequest> request = new DefaultRequest<InitiateLayerUploadRequest>(initiateLayerUploadRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.InitiateLayerUpload");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (initiateLayerUploadRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(initiateLayerUploadRequest.getRegistryId());
            }
            if (initiateLayerUploadRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(initiateLayerUploadRequest.getRepositoryName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

