/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Resource
implements Serializable,
Cloneable {
    private String name;
    private String type;
    private Double doubleValue;
    private Long longValue;
    private Integer integerValue;
    private SdkInternalList<String> stringSetValue;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Resource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Resource withType(String type) {
        this.setType(type);
        return this;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public Resource withDoubleValue(Double doubleValue) {
        this.setDoubleValue(doubleValue);
        return this;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public Resource withLongValue(Long longValue) {
        this.setLongValue(longValue);
        return this;
    }

    public void setIntegerValue(Integer integerValue) {
        this.integerValue = integerValue;
    }

    public Integer getIntegerValue() {
        return this.integerValue;
    }

    public Resource withIntegerValue(Integer integerValue) {
        this.setIntegerValue(integerValue);
        return this;
    }

    public List<String> getStringSetValue() {
        if (this.stringSetValue == null) {
            this.stringSetValue = new SdkInternalList();
        }
        return this.stringSetValue;
    }

    public void setStringSetValue(Collection<String> stringSetValue) {
        if (stringSetValue == null) {
            this.stringSetValue = null;
            return;
        }
        this.stringSetValue = new SdkInternalList<String>(stringSetValue);
    }

    public Resource withStringSetValue(String ... stringSetValue) {
        if (this.stringSetValue == null) {
            this.setStringSetValue(new SdkInternalList<String>(stringSetValue.length));
        }
        for (String ele : stringSetValue) {
            this.stringSetValue.add(ele);
        }
        return this;
    }

    public Resource withStringSetValue(Collection<String> stringSetValue) {
        this.setStringSetValue(stringSetValue);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getDoubleValue() != null) {
            sb.append("DoubleValue: " + this.getDoubleValue() + ",");
        }
        if (this.getLongValue() != null) {
            sb.append("LongValue: " + this.getLongValue() + ",");
        }
        if (this.getIntegerValue() != null) {
            sb.append("IntegerValue: " + this.getIntegerValue() + ",");
        }
        if (this.getStringSetValue() != null) {
            sb.append("StringSetValue: " + this.getStringSetValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDoubleValue() == null ^ this.getDoubleValue() == null) {
            return false;
        }
        if (other.getDoubleValue() != null && !other.getDoubleValue().equals(this.getDoubleValue())) {
            return false;
        }
        if (other.getLongValue() == null ^ this.getLongValue() == null) {
            return false;
        }
        if (other.getLongValue() != null && !other.getLongValue().equals(this.getLongValue())) {
            return false;
        }
        if (other.getIntegerValue() == null ^ this.getIntegerValue() == null) {
            return false;
        }
        if (other.getIntegerValue() != null && !other.getIntegerValue().equals(this.getIntegerValue())) {
            return false;
        }
        if (other.getStringSetValue() == null ^ this.getStringSetValue() == null) {
            return false;
        }
        return other.getStringSetValue() == null || other.getStringSetValue().equals(this.getStringSetValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDoubleValue() == null ? 0 : this.getDoubleValue().hashCode());
        hashCode = 31 * hashCode + (this.getLongValue() == null ? 0 : this.getLongValue().hashCode());
        hashCode = 31 * hashCode + (this.getIntegerValue() == null ? 0 : this.getIntegerValue().hashCode());
        hashCode = 31 * hashCode + (this.getStringSetValue() == null ? 0 : this.getStringSetValue().hashCode());
        return hashCode;
    }

    public Resource clone() {
        try {
            return (Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

