/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AddJobFlowStepsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobFlowId;
    private SdkInternalList<StepConfig> steps;

    public AddJobFlowStepsRequest() {
    }

    public AddJobFlowStepsRequest(String jobFlowId) {
        this.setJobFlowId(jobFlowId);
    }

    public AddJobFlowStepsRequest(String jobFlowId, List<StepConfig> steps) {
        this.setJobFlowId(jobFlowId);
        this.setSteps(steps);
    }

    public void setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
    }

    public String getJobFlowId() {
        return this.jobFlowId;
    }

    public AddJobFlowStepsRequest withJobFlowId(String jobFlowId) {
        this.setJobFlowId(jobFlowId);
        return this;
    }

    public List<StepConfig> getSteps() {
        if (this.steps == null) {
            this.steps = new SdkInternalList();
        }
        return this.steps;
    }

    public void setSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new SdkInternalList<StepConfig>(steps);
    }

    public AddJobFlowStepsRequest withSteps(StepConfig ... steps) {
        if (this.steps == null) {
            this.setSteps(new SdkInternalList<StepConfig>(steps.length));
        }
        for (StepConfig ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public AddJobFlowStepsRequest withSteps(Collection<StepConfig> steps) {
        this.setSteps(steps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobFlowId() != null) {
            sb.append("JobFlowId: " + this.getJobFlowId() + ",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: " + this.getSteps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsRequest)) {
            return false;
        }
        AddJobFlowStepsRequest other = (AddJobFlowStepsRequest)obj;
        if (other.getJobFlowId() == null ^ this.getJobFlowId() == null) {
            return false;
        }
        if (other.getJobFlowId() != null && !other.getJobFlowId().equals(this.getJobFlowId())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        return other.getSteps() == null || other.getSteps().equals(this.getSteps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobFlowId() == null ? 0 : this.getJobFlowId().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        return hashCode;
    }

    @Override
    public AddJobFlowStepsRequest clone() {
        return (AddJobFlowStepsRequest)super.clone();
    }
}

