/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.ListFleetsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListFleetsRequestMarshaller
implements Marshaller<Request<ListFleetsRequest>, ListFleetsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListFleetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListFleetsRequest> marshall(ListFleetsRequest listFleetsRequest) {
        if (listFleetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListFleetsRequest> request = new DefaultRequest<ListFleetsRequest>(listFleetsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListFleets");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listFleetsRequest.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(listFleetsRequest.getBuildId());
            }
            if (listFleetsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listFleetsRequest.getLimit());
            }
            if (listFleetsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listFleetsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

