/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetJobOutputRequestMarshaller
implements Marshaller<Request<GetJobOutputRequest>, GetJobOutputRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public GetJobOutputRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetJobOutputRequest> marshall(GetJobOutputRequest getJobOutputRequest) {
        if (getJobOutputRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetJobOutputRequest> request = new DefaultRequest<GetJobOutputRequest>(getJobOutputRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        if (getJobOutputRequest.getRange() != null) {
            request.addHeader("Range", StringUtils.fromString(getJobOutputRequest.getRange()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output";
        uriResourcePath = uriResourcePath.replace("{accountId}", getJobOutputRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getJobOutputRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", getJobOutputRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getJobOutputRequest.getVaultName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{jobId}", getJobOutputRequest.getJobId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getJobOutputRequest.getJobId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

