/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListPartsRequestMarshaller
implements Marshaller<Request<ListPartsRequest>, ListPartsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListPartsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListPartsRequest> marshall(ListPartsRequest listPartsRequest) {
        if (listPartsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPartsRequest> request = new DefaultRequest<ListPartsRequest>(listPartsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", listPartsRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listPartsRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", listPartsRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listPartsRequest.getVaultName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{uploadId}", listPartsRequest.getUploadId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listPartsRequest.getUploadId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listPartsRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString(listPartsRequest.getMarker()));
        }
        if (listPartsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromString(listPartsRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

