/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.UpdateCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class UpdateCertificateRequestMarshaller
implements Marshaller<Request<UpdateCertificateRequest>, UpdateCertificateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateCertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateCertificateRequest> marshall(UpdateCertificateRequest updateCertificateRequest) {
        if (updateCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateCertificateRequest> request = new DefaultRequest<UpdateCertificateRequest>(updateCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/certificates/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", updateCertificateRequest.getCertificateId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateCertificateRequest.getCertificateId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (updateCertificateRequest.getNewStatus() != null) {
            request.addParameter("newStatus", StringUtils.fromString(updateCertificateRequest.getNewStatus()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

