/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetRecordsRequestMarshaller
implements Marshaller<Request<GetRecordsRequest>, GetRecordsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetRecordsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetRecordsRequest> marshall(GetRecordsRequest getRecordsRequest) {
        if (getRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetRecordsRequest> request = new DefaultRequest<GetRecordsRequest>(getRecordsRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.GetRecords");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getRecordsRequest.getShardIterator() != null) {
                jsonGenerator.writeFieldName("ShardIterator").writeValue(getRecordsRequest.getShardIterator());
            }
            if (getRecordsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(getRecordsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

