/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.RegisterInstanceRequest;
import com.amazonaws.services.opsworks.model.transform.InstanceIdentityJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RegisterInstanceRequestMarshaller
implements Marshaller<Request<RegisterInstanceRequest>, RegisterInstanceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterInstanceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RegisterInstanceRequest> marshall(RegisterInstanceRequest registerInstanceRequest) {
        if (registerInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterInstanceRequest> request = new DefaultRequest<RegisterInstanceRequest>(registerInstanceRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.RegisterInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerInstanceRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(registerInstanceRequest.getStackId());
            }
            if (registerInstanceRequest.getHostname() != null) {
                jsonGenerator.writeFieldName("Hostname").writeValue(registerInstanceRequest.getHostname());
            }
            if (registerInstanceRequest.getPublicIp() != null) {
                jsonGenerator.writeFieldName("PublicIp").writeValue(registerInstanceRequest.getPublicIp());
            }
            if (registerInstanceRequest.getPrivateIp() != null) {
                jsonGenerator.writeFieldName("PrivateIp").writeValue(registerInstanceRequest.getPrivateIp());
            }
            if (registerInstanceRequest.getRsaPublicKey() != null) {
                jsonGenerator.writeFieldName("RsaPublicKey").writeValue(registerInstanceRequest.getRsaPublicKey());
            }
            if (registerInstanceRequest.getRsaPublicKeyFingerprint() != null) {
                jsonGenerator.writeFieldName("RsaPublicKeyFingerprint").writeValue(registerInstanceRequest.getRsaPublicKeyFingerprint());
            }
            if (registerInstanceRequest.getInstanceIdentity() != null) {
                jsonGenerator.writeFieldName("InstanceIdentity");
                InstanceIdentityJsonMarshaller.getInstance().marshall(registerInstanceRequest.getInstanceIdentity(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

