/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.AvailabilityZone;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class OrderableClusterOption
implements Serializable,
Cloneable {
    private String clusterVersion;
    private String clusterType;
    private String nodeType;
    private SdkInternalList<AvailabilityZone> availabilityZones;

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public OrderableClusterOption withClusterVersion(String clusterVersion) {
        this.setClusterVersion(clusterVersion);
        return this;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public OrderableClusterOption withClusterType(String clusterType) {
        this.setClusterType(clusterType);
        return this;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public OrderableClusterOption withNodeType(String nodeType) {
        this.setNodeType(nodeType);
        return this;
    }

    public List<AvailabilityZone> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList<AvailabilityZone>(availabilityZones);
    }

    public OrderableClusterOption withAvailabilityZones(AvailabilityZone ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new SdkInternalList<AvailabilityZone>(availabilityZones.length));
        }
        for (AvailabilityZone ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public OrderableClusterOption withAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: " + this.getClusterVersion() + ",");
        }
        if (this.getClusterType() != null) {
            sb.append("ClusterType: " + this.getClusterType() + ",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: " + this.getNodeType() + ",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableClusterOption)) {
            return false;
        }
        OrderableClusterOption other = (OrderableClusterOption)obj;
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.getClusterType() == null ^ this.getClusterType() == null) {
            return false;
        }
        if (other.getClusterType() != null && !other.getClusterType().equals(this.getClusterType())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        return other.getAvailabilityZones() == null || other.getAvailabilityZones().equals(this.getAvailabilityZones());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getClusterType() == null ? 0 : this.getClusterType().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        return hashCode;
    }

    public OrderableClusterOption clone() {
        try {
            return (OrderableClusterOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

