/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.Nameserver;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversRequest;
import com.amazonaws.services.route53domains.model.transform.NameserverJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateDomainNameserversRequestMarshaller
implements Marshaller<Request<UpdateDomainNameserversRequest>, UpdateDomainNameserversRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateDomainNameserversRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateDomainNameserversRequest> marshall(UpdateDomainNameserversRequest updateDomainNameserversRequest) {
        if (updateDomainNameserversRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDomainNameserversRequest> request = new DefaultRequest<UpdateDomainNameserversRequest>(updateDomainNameserversRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.UpdateDomainNameservers");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList nameserversList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateDomainNameserversRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(updateDomainNameserversRequest.getDomainName());
            }
            if (updateDomainNameserversRequest.getFIAuthKey() != null) {
                jsonGenerator.writeFieldName("FIAuthKey").writeValue(updateDomainNameserversRequest.getFIAuthKey());
            }
            if (!(nameserversList = (SdkInternalList)updateDomainNameserversRequest.getNameservers()).isEmpty() || !nameserversList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Nameservers");
                jsonGenerator.writeStartArray();
                for (Nameserver nameserversListValue : nameserversList) {
                    if (nameserversListValue == null) continue;
                    NameserverJsonMarshaller.getInstance().marshall(nameserversListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

