/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.ModifyDocumentPermissionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ModifyDocumentPermissionRequestMarshaller
implements Marshaller<Request<ModifyDocumentPermissionRequest>, ModifyDocumentPermissionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ModifyDocumentPermissionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ModifyDocumentPermissionRequest> marshall(ModifyDocumentPermissionRequest modifyDocumentPermissionRequest) {
        if (modifyDocumentPermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyDocumentPermissionRequest> request = new DefaultRequest<ModifyDocumentPermissionRequest>(modifyDocumentPermissionRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ModifyDocumentPermission");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList accountIdsToRemoveList;
            SdkInternalList accountIdsToAddList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (modifyDocumentPermissionRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(modifyDocumentPermissionRequest.getName());
            }
            if (modifyDocumentPermissionRequest.getPermissionType() != null) {
                jsonGenerator.writeFieldName("PermissionType").writeValue(modifyDocumentPermissionRequest.getPermissionType());
            }
            if (!(accountIdsToAddList = (SdkInternalList)modifyDocumentPermissionRequest.getAccountIdsToAdd()).isEmpty() || !accountIdsToAddList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AccountIdsToAdd");
                jsonGenerator.writeStartArray();
                for (String accountIdsToAddListValue : accountIdsToAddList) {
                    if (accountIdsToAddListValue == null) continue;
                    jsonGenerator.writeValue(accountIdsToAddListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(accountIdsToRemoveList = (SdkInternalList)modifyDocumentPermissionRequest.getAccountIdsToRemove()).isEmpty() || !accountIdsToRemoveList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AccountIdsToRemove");
                jsonGenerator.writeStartArray();
                for (String accountIdsToRemoveListValue : accountIdsToRemoveList) {
                    if (accountIdsToRemoveListValue == null) continue;
                    jsonGenerator.writeValue(accountIdsToRemoveListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

