/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PollForActivityTaskRequestMarshaller
implements Marshaller<Request<PollForActivityTaskRequest>, PollForActivityTaskRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PollForActivityTaskRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PollForActivityTaskRequest> marshall(PollForActivityTaskRequest pollForActivityTaskRequest) {
        if (pollForActivityTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PollForActivityTaskRequest> request = new DefaultRequest<PollForActivityTaskRequest>(pollForActivityTaskRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.PollForActivityTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (pollForActivityTaskRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(pollForActivityTaskRequest.getDomain());
            }
            if (pollForActivityTaskRequest.getTaskList() != null) {
                jsonGenerator.writeFieldName("taskList");
                TaskListJsonMarshaller.getInstance().marshall(pollForActivityTaskRequest.getTaskList(), jsonGenerator);
            }
            if (pollForActivityTaskRequest.getIdentity() != null) {
                jsonGenerator.writeFieldName("identity").writeValue(pollForActivityTaskRequest.getIdentity());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

