/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RespondActivityTaskFailedRequestMarshaller
implements Marshaller<Request<RespondActivityTaskFailedRequest>, RespondActivityTaskFailedRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RespondActivityTaskFailedRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RespondActivityTaskFailedRequest> marshall(RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) {
        if (respondActivityTaskFailedRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RespondActivityTaskFailedRequest> request = new DefaultRequest<RespondActivityTaskFailedRequest>(respondActivityTaskFailedRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.RespondActivityTaskFailed");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (respondActivityTaskFailedRequest.getTaskToken() != null) {
                jsonGenerator.writeFieldName("taskToken").writeValue(respondActivityTaskFailedRequest.getTaskToken());
            }
            if (respondActivityTaskFailedRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(respondActivityTaskFailedRequest.getReason());
            }
            if (respondActivityTaskFailedRequest.getDetails() != null) {
                jsonGenerator.writeFieldName("details").writeValue(respondActivityTaskFailedRequest.getDetails());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

