/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeConfiguration;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;

public class WorkflowTypeConfigurationJsonMarshaller {
    private static WorkflowTypeConfigurationJsonMarshaller instance;

    public void marshall(WorkflowTypeConfiguration workflowTypeConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (workflowTypeConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (workflowTypeConfiguration.getDefaultTaskStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultTaskStartToCloseTimeout").writeValue(workflowTypeConfiguration.getDefaultTaskStartToCloseTimeout());
            }
            if (workflowTypeConfiguration.getDefaultExecutionStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("defaultExecutionStartToCloseTimeout").writeValue(workflowTypeConfiguration.getDefaultExecutionStartToCloseTimeout());
            }
            if (workflowTypeConfiguration.getDefaultTaskList() != null) {
                jsonGenerator.writeFieldName("defaultTaskList");
                TaskListJsonMarshaller.getInstance().marshall(workflowTypeConfiguration.getDefaultTaskList(), jsonGenerator);
            }
            if (workflowTypeConfiguration.getDefaultTaskPriority() != null) {
                jsonGenerator.writeFieldName("defaultTaskPriority").writeValue(workflowTypeConfiguration.getDefaultTaskPriority());
            }
            if (workflowTypeConfiguration.getDefaultChildPolicy() != null) {
                jsonGenerator.writeFieldName("defaultChildPolicy").writeValue(workflowTypeConfiguration.getDefaultChildPolicy());
            }
            if (workflowTypeConfiguration.getDefaultLambdaRole() != null) {
                jsonGenerator.writeFieldName("defaultLambdaRole").writeValue(workflowTypeConfiguration.getDefaultLambdaRole());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkflowTypeConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkflowTypeConfigurationJsonMarshaller();
        }
        return instance;
    }
}

