/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.SizeConstraint;
import com.amazonaws.services.waf.model.SizeConstraintSet;
import com.amazonaws.services.waf.model.transform.SizeConstraintJsonMarshaller;
import java.util.List;

public class SizeConstraintSetJsonMarshaller {
    private static SizeConstraintSetJsonMarshaller instance;

    public void marshall(SizeConstraintSet sizeConstraintSet, StructuredJsonGenerator jsonGenerator) {
        if (sizeConstraintSet == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<SizeConstraint> sizeConstraintsList;
            jsonGenerator.writeStartObject();
            if (sizeConstraintSet.getSizeConstraintSetId() != null) {
                jsonGenerator.writeFieldName("SizeConstraintSetId").writeValue(sizeConstraintSet.getSizeConstraintSetId());
            }
            if (sizeConstraintSet.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(sizeConstraintSet.getName());
            }
            if ((sizeConstraintsList = sizeConstraintSet.getSizeConstraints()) != null) {
                jsonGenerator.writeFieldName("SizeConstraints");
                jsonGenerator.writeStartArray();
                for (SizeConstraint sizeConstraintsListValue : sizeConstraintsList) {
                    if (sizeConstraintsListValue == null) continue;
                    SizeConstraintJsonMarshaller.getInstance().marshall(sizeConstraintsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SizeConstraintSetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SizeConstraintSetJsonMarshaller();
        }
        return instance;
    }
}

